#include <bits/stdc++.h>

using namespace std;

const int mxN = (1 << 20) + 3, LOG = 20;
int bit[mxN];
void add(int idx, int x) {
    for (; idx < mxN; idx |= (idx + 1)) {
        bit[idx]+=x;
    }
}
int sum(int idx) {
    int s = 0;
    for (; idx >= 0; idx = (idx & (idx + 1)) - 1) {
        s += bit[idx];
    }
    return s;
}
int bef[mxN][LOG], aft[mxN][LOG], lg2[mxN];
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    lg2[1] = 0;
    for (int i = 0; i < mxN; ++i) {
        if (i)  lg2[i+1] = lg2[(i+1)/2]+1;
        add(i, 1);
        bef[i][0] = ((i & 1) ? i-1 : i);
        aft[i][0] = ((i & 1) ? i : i+1);
        for (int j = 1; j < LOG; ++j) {
            if ((1 << j) & i) {
                bef[i][j] = bef[i][j-1]-(1 << j);
                aft[i][j] = aft[i][j-1];
            }
            else {
                bef[i][j] = bef[i][j-1];
                aft[i][j] = aft[i][j-1]+(1 << j);
            }
        }
    }
    // O(q * (log (log n)) * (log n))
    int n;
    cin >> n;
    vector<int> p(n+1), pos(n+1);
    for (int i = 0; i < n; ++i) {
        cin >> p[i];
        p[i]--;
        pos[p[i]] = i;
    }
    int q;
    cin >> q;
    vector<pair<int, int>> qu[n];
    for (int i = 0; i < q; ++i) {
        int m, c;
        cin >> m >> c;
        m--;
        qu[p[m]].push_back({c, i});
    }
    vector<int> ans(q, 1);
    add(pos[0], -1);
    for (int i = 1; i < n; ++i) {
        add(pos[i], -1);
        for (auto u : qu[i]) {
            int l = 0, r = lg2[i+1]-1;
            while (l <= r) {
                int mid = (l + r)/2;
                if (sum(aft[pos[i]][mid]) - (bef[pos[i]][mid] == 0 ? 0 : sum(bef[pos[i]][mid]-1)) <= u.first) {
                    l = mid+1;
                    ans[u.second] = mid+2;
                }
                else {
                    r = mid-1;
                }
            }
        }
    }
    for (int i = 0; i < q; ++i)  {
        cout << ans[i] << ' ';
    }
}